/*
 * Decompiled with CFR 0.152.
 */
package locusway.overloadedarmorbar;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import locusway.overloadedarmorbar.overlay.ArmorBarRenderer;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static String[] colorValues;
    public static int[] colorValuesI;
    public static boolean alwaysShowArmorBar;
    public static boolean showEmptyArmorIcons;
    private static final Pattern colorPattern;

    public ConfigurationHandler(File configDir) {
        if (config == null) {
            config = new Configuration(configDir);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        alwaysShowArmorBar = config.getBoolean("Always Show armor bar?", "general", false, "Always show armor bar");
        colorValues = config.getStringList("Armor Icon Colors", "general", new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}, "Colors must be specified in #RRGGBB format");
        showEmptyArmorIcons = config.getBoolean("Show empty armor icons?", "general", false, "Show empty armor icons");
        ConfigurationHandler.fillColorValuesI();
        if (config.hasChanged()) {
            config.save();
            ArmorBarRenderer.forceUpdate();
        }
    }

    private static void fillColorValuesI() {
        colorValuesI = new int[colorValues.length];
        for (int i = 0; i < colorValues.length; ++i) {
            ConfigurationHandler.colorValuesI[i] = ConfigurationHandler.parseColor(colorValues[i]);
        }
    }

    private static int parseColor(String colorValue) {
        Matcher matcher = colorPattern.matcher(colorValue);
        if (matcher.matches()) {
            return Integer.parseInt(colorValue.substring(1, 7), 16);
        }
        return 0xFFFFFF;
    }

    @SubscribeEvent
    public void onConfigurationChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("overloadedarmorbar")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        colorValues = new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"};
        alwaysShowArmorBar = false;
        showEmptyArmorIcons = false;
        colorPattern = Pattern.compile("^#[0-9A-Fa-f]{6}$");
    }
}

